#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int x, y;
} Point;

int compare(const void *a, const void *b) {
    Point *p1 = (Point *)a, *p2 = (Point *)b;
    if (p1->x != p2->x) return p1->x - p2->x;
    return p1->y - p2->y;
}

long long area(Point *hull, int n) {
    long long res = 0;
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        res += (long long) hull[i].x * hull[j].y - (long long) hull[j].x * hull[i].y;
    }
    return abs(res) / 2;
}

int cross(Point o, Point a, Point b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

int convexHull(Point *points, int n, Point *hull) {
    qsort(points, n, sizeof(Point), compare);

    int top = 0;
    for (int i = 0; i < n; i++) {
        while (top >= 2 && cross(hull[top - 2], hull[top - 1], points[i]) <= 0)
            top--;
        hull[top++] = points[i];
    }

    int lower = top;
    for (int i = n - 2; i >= 0; i--) {
        while (top >= lower && cross(hull[top - 2], hull[top - 1], points[i]) <= 0)
            top--;
        hull[top++] = points[i];
    }

    return top - 1;
}

int main() {
    int N;
    scanf("%d", &N);

    Point points[N];
    for (int i = 0; i < N; i++) {
        scanf("%d %d", &points[i].x, &points[i].y);
    }

    Point hull[N];
    int hullSize = convexHull(points, N, hull);

    long long fullArea = area(hull, hullSize);

    long long minArea = fullArea;

    for (int i = 0; i < N; i++) {
        Point newPoints[N - 1];
        int idx = 0;
        for (int j = 0; j < N; j++) {
            if (i != j) newPoints[idx++] = points[j];
        }

        int newHullSize = convexHull(newPoints, N - 1, hull);
        long long newArea = area(hull, newHullSize);
        if (newArea < minArea) minArea = newArea;
    }

    printf("%lld\n", minArea);
    return 0;
}